<?php

// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

namespace Algolia\AlgoliaSearch\Api;

use Algolia\AlgoliaSearch\Algolia;
use Algolia\AlgoliaSearch\Configuration\IngestionConfig;
use Algolia\AlgoliaSearch\Exceptions\ExceededRetriesException;
use Algolia\AlgoliaSearch\Exceptions\NotFoundException;
use Algolia\AlgoliaSearch\Model\Ingestion\Authentication;
use Algolia\AlgoliaSearch\Model\Ingestion\AuthenticationCreate;
use Algolia\AlgoliaSearch\Model\Ingestion\AuthenticationCreateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\AuthenticationSearch;
use Algolia\AlgoliaSearch\Model\Ingestion\AuthenticationUpdate;
use Algolia\AlgoliaSearch\Model\Ingestion\AuthenticationUpdateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\DeleteResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\Destination;
use Algolia\AlgoliaSearch\Model\Ingestion\DestinationCreate;
use Algolia\AlgoliaSearch\Model\Ingestion\DestinationCreateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\DestinationSearch;
use Algolia\AlgoliaSearch\Model\Ingestion\DestinationUpdate;
use Algolia\AlgoliaSearch\Model\Ingestion\DestinationUpdateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\Event;
use Algolia\AlgoliaSearch\Model\Ingestion\ListAuthenticationsResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\ListDestinationsResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\ListEventsResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\ListSourcesResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\ListTasksResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\ListTasksResponseV1;
use Algolia\AlgoliaSearch\Model\Ingestion\ListTransformationsResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\PushTaskPayload;
use Algolia\AlgoliaSearch\Model\Ingestion\Run;
use Algolia\AlgoliaSearch\Model\Ingestion\RunListResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\RunResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\RunSourcePayload;
use Algolia\AlgoliaSearch\Model\Ingestion\RunSourceResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\RunTaskPayload;
use Algolia\AlgoliaSearch\Model\Ingestion\Source;
use Algolia\AlgoliaSearch\Model\Ingestion\SourceCreate;
use Algolia\AlgoliaSearch\Model\Ingestion\SourceCreateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\SourceSearch;
use Algolia\AlgoliaSearch\Model\Ingestion\SourceUpdate;
use Algolia\AlgoliaSearch\Model\Ingestion\SourceUpdateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\Task;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskCreate;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskCreateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskCreateV1;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskReplace;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskSearch;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskUpdate;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskUpdateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskUpdateV1;
use Algolia\AlgoliaSearch\Model\Ingestion\TaskV1;
use Algolia\AlgoliaSearch\Model\Ingestion\Transformation;
use Algolia\AlgoliaSearch\Model\Ingestion\TransformationCreate;
use Algolia\AlgoliaSearch\Model\Ingestion\TransformationCreateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\TransformationSearch;
use Algolia\AlgoliaSearch\Model\Ingestion\TransformationTry;
use Algolia\AlgoliaSearch\Model\Ingestion\TransformationTryResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\TransformationUpdateResponse;
use Algolia\AlgoliaSearch\Model\Ingestion\WatchResponse;
use Algolia\AlgoliaSearch\ObjectSerializer;
use Algolia\AlgoliaSearch\RetryStrategy\ApiWrapper;
use Algolia\AlgoliaSearch\RetryStrategy\ApiWrapperInterface;
use Algolia\AlgoliaSearch\RetryStrategy\ClusterHosts;
use GuzzleHttp\Psr7\Query;

/**
 * IngestionClient Class Doc Comment.
 *
 * @category Class
 */
class IngestionClient
{
    public const VERSION = '4.36.0';

    /**
     * @var ApiWrapperInterface
     */
    protected $api;

    /**
     * @var IngestionClient
     */
    protected $ingestionTransporter;

    /**
     * @var IngestionConfig
     */
    protected $config;

    public function __construct(ApiWrapperInterface $apiWrapper, IngestionConfig $config)
    {
        $this->config = $config;
        $this->api = $apiWrapper;
    }

    /**
     * Instantiate the client with basic credentials and region.
     *
     * @param string $appId  Application ID
     * @param string $apiKey Algolia API Key
     * @param string $region Region
     */
    public static function create($appId = null, $apiKey = null, $region = null)
    {
        $config = IngestionConfig::create($appId, $apiKey, $region);

        return static::createWithConfig($config);
    }

    /**
     * Instantiate the client with configuration.
     *
     * @param IngestionConfig $config Configuration
     */
    public static function createWithConfig(IngestionConfig $config)
    {
        $config = clone $config;

        $apiWrapper = new ApiWrapper(
            Algolia::getHttpClient(),
            $config,
            self::getClusterHosts($config)
        );

        $client = new static($apiWrapper, $config);

        return $client;
    }

    /**
     * Gets the cluster hosts depending on the config.
     *
     * @return ClusterHosts
     */
    public static function getClusterHosts(IngestionConfig $config)
    {
        if ($hosts = $config->getHosts()) {
            // If a list of hosts was passed, we ignore the cache
            $clusterHosts = ClusterHosts::create($hosts);
        } else {
            $url = null !== $config->getRegion() && '' !== $config->getRegion()
                ? str_replace('{region}', $config->getRegion(), 'data.{region}.algolia.com')
                : '';
            $clusterHosts = ClusterHosts::create($url);
        }

        return $clusterHosts;
    }

    /**
     * @return IngestionConfig
     */
    public function getClientConfig()
    {
        return $this->config;
    }

    /**
     * Stub method setting a new API key to authenticate requests.
     *
     * @param string $apiKey
     */
    public function setClientApiKey($apiKey)
    {
        $this->config->setClientApiKey($apiKey);
    }

    /**
     * Creates a new authentication resource.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|AuthenticationCreate $authenticationCreate (required)
     *                                                         - $authenticationCreate['type'] => (array)  (required)
     *                                                         - $authenticationCreate['name'] => (string) Descriptive name for the resource. (required)
     *                                                         - $authenticationCreate['platform'] => (array)
     *                                                         - $authenticationCreate['input'] => (array)  (required)
     *
     * @see AuthenticationCreate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|AuthenticationCreateResponse
     */
    public function createAuthentication($authenticationCreate, $requestOptions = [])
    {
        // verify the required parameter 'authenticationCreate' is set
        if (!isset($authenticationCreate)) {
            throw new \InvalidArgumentException(
                'Parameter `authenticationCreate` is required when calling `createAuthentication`.'
            );
        }

        $resourcePath = '/1/authentications';
        $queryParameters = [];
        $headers = [];
        $httpBody = $authenticationCreate;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Creates a new destination.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|DestinationCreate $destinationCreate (required)
     *                                                   - $destinationCreate['type'] => (array)  (required)
     *                                                   - $destinationCreate['name'] => (string) Descriptive name for the resource. (required)
     *                                                   - $destinationCreate['input'] => (array)  (required)
     *                                                   - $destinationCreate['authenticationID'] => (string) Universally unique identifier (UUID) of an authentication resource.
     *                                                   - $destinationCreate['transformationIDs'] => (array)
     *
     * @see DestinationCreate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|DestinationCreateResponse
     */
    public function createDestination($destinationCreate, $requestOptions = [])
    {
        // verify the required parameter 'destinationCreate' is set
        if (!isset($destinationCreate)) {
            throw new \InvalidArgumentException(
                'Parameter `destinationCreate` is required when calling `createDestination`.'
            );
        }

        $resourcePath = '/1/destinations';
        $queryParameters = [];
        $headers = [];
        $httpBody = $destinationCreate;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Creates a new source.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|SourceCreate $sourceCreate (required)
     *                                         - $sourceCreate['type'] => (array)  (required)
     *                                         - $sourceCreate['name'] => (string) Descriptive name of the source. (required)
     *                                         - $sourceCreate['input'] => (array)
     *                                         - $sourceCreate['authenticationID'] => (string) Universally unique identifier (UUID) of an authentication resource.
     *
     * @see SourceCreate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|SourceCreateResponse
     */
    public function createSource($sourceCreate, $requestOptions = [])
    {
        // verify the required parameter 'sourceCreate' is set
        if (!isset($sourceCreate)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceCreate` is required when calling `createSource`.'
            );
        }

        $resourcePath = '/1/sources';
        $queryParameters = [];
        $headers = [];
        $httpBody = $sourceCreate;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Creates a new task.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|TaskCreate $taskCreate Request body for creating a task. (required)
     *                                     - $taskCreate['sourceID'] => (string) Universally uniqud identifier (UUID) of a source. (required)
     *                                     - $taskCreate['destinationID'] => (string) Universally unique identifier (UUID) of a destination resource. (required)
     *                                     - $taskCreate['action'] => (array)  (required)
     *                                     - $taskCreate['subscriptionAction'] => (array)
     *                                     - $taskCreate['cron'] => (string) Cron expression for the task's schedule.
     *                                     - $taskCreate['enabled'] => (bool) Whether the task is enabled.
     *                                     - $taskCreate['failureThreshold'] => (int) Maximum accepted percentage of failures for a task run to finish successfully.
     *                                     - $taskCreate['input'] => (array)
     *                                     - $taskCreate['cursor'] => (string) Date of the last cursor in RFC 3339 format.
     *                                     - $taskCreate['notifications'] => (array)
     *                                     - $taskCreate['policies'] => (array)
     *
     * @see TaskCreate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskCreateResponse
     */
    public function createTask($taskCreate, $requestOptions = [])
    {
        // verify the required parameter 'taskCreate' is set
        if (!isset($taskCreate)) {
            throw new \InvalidArgumentException(
                'Parameter `taskCreate` is required when calling `createTask`.'
            );
        }

        $resourcePath = '/2/tasks';
        $queryParameters = [];
        $headers = [];
        $httpBody = $taskCreate;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Creates a new task using the v1 endpoint, please use `createTask` instead.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|TaskCreateV1 $taskCreate Request body for creating a task. (required)
     *                                       - $taskCreate['sourceID'] => (string) Universally uniqud identifier (UUID) of a source. (required)
     *                                       - $taskCreate['destinationID'] => (string) Universally unique identifier (UUID) of a destination resource. (required)
     *                                       - $taskCreate['trigger'] => (array)  (required)
     *                                       - $taskCreate['action'] => (array)  (required)
     *                                       - $taskCreate['enabled'] => (bool) Whether the task is enabled.
     *                                       - $taskCreate['failureThreshold'] => (int) Maximum accepted percentage of failures for a task run to finish successfully.
     *                                       - $taskCreate['input'] => (array)
     *                                       - $taskCreate['cursor'] => (string) Date of the last cursor in RFC 3339 format.
     *
     * @see TaskCreateV1
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskCreateResponse
     *
     * @deprecated
     */
    public function createTaskV1($taskCreate, $requestOptions = [])
    {
        // verify the required parameter 'taskCreate' is set
        if (!isset($taskCreate)) {
            throw new \InvalidArgumentException(
                'Parameter `taskCreate` is required when calling `createTaskV1`.'
            );
        }

        $resourcePath = '/1/tasks';
        $queryParameters = [];
        $headers = [];
        $httpBody = $taskCreate;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Creates a new transformation.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|TransformationCreate $transformationCreate Request body for creating a transformation. (required)
     *                                                         - $transformationCreate['code'] => (string) It is deprecated. Use the `input` field with proper `type` instead to specify the transformation code.
     *                                                         - $transformationCreate['name'] => (string) The uniquely identified name of your transformation. (required)
     *                                                         - $transformationCreate['type'] => (array)
     *                                                         - $transformationCreate['input'] => (array)
     *                                                         - $transformationCreate['description'] => (string) A descriptive name for your transformation of what it does.
     *                                                         - $transformationCreate['authenticationIDs'] => (array) The authentications associated with the current transformation.
     *
     * @see TransformationCreate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TransformationCreateResponse
     */
    public function createTransformation($transformationCreate, $requestOptions = [])
    {
        // verify the required parameter 'transformationCreate' is set
        if (!isset($transformationCreate)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationCreate` is required when calling `createTransformation`.'
            );
        }

        $resourcePath = '/1/transformations';
        $queryParameters = [];
        $headers = [];
        $httpBody = $transformationCreate;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * This method lets you send requests to the Algolia REST API.
     *
     * @param string $path           Path of the endpoint, for example `1/newFeature`. (required)
     * @param array  $parameters     Query parameters to apply to the current query. (optional)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|object
     */
    public function customDelete($path, $parameters = null, $requestOptions = [])
    {
        // verify the required parameter 'path' is set
        if (!isset($path)) {
            throw new \InvalidArgumentException(
                'Parameter `path` is required when calling `customDelete`.'
            );
        }

        $resourcePath = '/{path}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $parameters) {
            $queryParameters = $parameters;
        }

        // path params
        if (null !== $path) {
            $resourcePath = str_replace(
                '{path}',
                $path,
                $resourcePath
            );
        }

        return $this->sendRequest('DELETE', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * This method lets you send requests to the Algolia REST API.
     *
     * @param string $path           Path of the endpoint, for example `1/newFeature`. (required)
     * @param array  $parameters     Query parameters to apply to the current query. (optional)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|object
     */
    public function customGet($path, $parameters = null, $requestOptions = [])
    {
        // verify the required parameter 'path' is set
        if (!isset($path)) {
            throw new \InvalidArgumentException(
                'Parameter `path` is required when calling `customGet`.'
            );
        }

        $resourcePath = '/{path}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $parameters) {
            $queryParameters = $parameters;
        }

        // path params
        if (null !== $path) {
            $resourcePath = str_replace(
                '{path}',
                $path,
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * This method lets you send requests to the Algolia REST API.
     *
     * @param string $path           Path of the endpoint, for example `1/newFeature`. (required)
     * @param array  $parameters     Query parameters to apply to the current query. (optional)
     * @param array  $body           Parameters to send with the custom request. (optional)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|object
     */
    public function customPost($path, $parameters = null, $body = null, $requestOptions = [])
    {
        // verify the required parameter 'path' is set
        if (!isset($path)) {
            throw new \InvalidArgumentException(
                'Parameter `path` is required when calling `customPost`.'
            );
        }

        $resourcePath = '/{path}';
        $queryParameters = [];
        $headers = [];
        $httpBody = isset($body) ? $body : [];

        if (null !== $parameters) {
            $queryParameters = $parameters;
        }

        // path params
        if (null !== $path) {
            $resourcePath = str_replace(
                '{path}',
                $path,
                $resourcePath
            );
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * This method lets you send requests to the Algolia REST API.
     *
     * @param string $path           Path of the endpoint, for example `1/newFeature`. (required)
     * @param array  $parameters     Query parameters to apply to the current query. (optional)
     * @param array  $body           Parameters to send with the custom request. (optional)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|object
     */
    public function customPut($path, $parameters = null, $body = null, $requestOptions = [])
    {
        // verify the required parameter 'path' is set
        if (!isset($path)) {
            throw new \InvalidArgumentException(
                'Parameter `path` is required when calling `customPut`.'
            );
        }

        $resourcePath = '/{path}';
        $queryParameters = [];
        $headers = [];
        $httpBody = isset($body) ? $body : [];

        if (null !== $parameters) {
            $queryParameters = $parameters;
        }

        // path params
        if (null !== $path) {
            $resourcePath = str_replace(
                '{path}',
                $path,
                $resourcePath
            );
        }

        return $this->sendRequest('PUT', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Deletes an authentication resource. You can't delete authentication resources that are used by a source or a destination.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $authenticationID Unique identifier of an authentication resource. (required)
     * @param array  $requestOptions   the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|DeleteResponse
     */
    public function deleteAuthentication($authenticationID, $requestOptions = [])
    {
        // verify the required parameter 'authenticationID' is set
        if (!isset($authenticationID)) {
            throw new \InvalidArgumentException(
                'Parameter `authenticationID` is required when calling `deleteAuthentication`.'
            );
        }

        $resourcePath = '/1/authentications/{authenticationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $authenticationID) {
            $resourcePath = str_replace(
                '{authenticationID}',
                ObjectSerializer::toPathValue($authenticationID),
                $resourcePath
            );
        }

        return $this->sendRequest('DELETE', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Deletes a destination by its ID. You can't delete destinations that are referenced in tasks.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $destinationID  Unique identifier of a destination. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|DeleteResponse
     */
    public function deleteDestination($destinationID, $requestOptions = [])
    {
        // verify the required parameter 'destinationID' is set
        if (!isset($destinationID)) {
            throw new \InvalidArgumentException(
                'Parameter `destinationID` is required when calling `deleteDestination`.'
            );
        }

        $resourcePath = '/1/destinations/{destinationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $destinationID) {
            $resourcePath = str_replace(
                '{destinationID}',
                ObjectSerializer::toPathValue($destinationID),
                $resourcePath
            );
        }

        return $this->sendRequest('DELETE', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Deletes a source by its ID. You can't delete sources that are referenced in tasks.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $sourceID       Unique identifier of a source. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|DeleteResponse
     */
    public function deleteSource($sourceID, $requestOptions = [])
    {
        // verify the required parameter 'sourceID' is set
        if (!isset($sourceID)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceID` is required when calling `deleteSource`.'
            );
        }

        $resourcePath = '/1/sources/{sourceID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $sourceID) {
            $resourcePath = str_replace(
                '{sourceID}',
                ObjectSerializer::toPathValue($sourceID),
                $resourcePath
            );
        }

        return $this->sendRequest('DELETE', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Deletes a task by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $taskID         Unique identifier of a task. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|DeleteResponse
     */
    public function deleteTask($taskID, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `deleteTask`.'
            );
        }

        $resourcePath = '/2/tasks/{taskID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('DELETE', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Deletes a task by its ID using the v1 endpoint, please use `deleteTask` instead.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $taskID         Unique identifier of a task. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|DeleteResponse
     *
     * @deprecated
     */
    public function deleteTaskV1($taskID, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `deleteTaskV1`.'
            );
        }

        $resourcePath = '/1/tasks/{taskID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('DELETE', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Deletes a transformation by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $transformationID Unique identifier of a transformation. (required)
     * @param array  $requestOptions   the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|DeleteResponse
     */
    public function deleteTransformation($transformationID, $requestOptions = [])
    {
        // verify the required parameter 'transformationID' is set
        if (!isset($transformationID)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationID` is required when calling `deleteTransformation`.'
            );
        }

        $resourcePath = '/1/transformations/{transformationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $transformationID) {
            $resourcePath = str_replace(
                '{transformationID}',
                ObjectSerializer::toPathValue($transformationID),
                $resourcePath
            );
        }

        return $this->sendRequest('DELETE', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Disables a task.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $taskID         Unique identifier of a task. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskUpdateResponse
     */
    public function disableTask($taskID, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `disableTask`.'
            );
        }

        $resourcePath = '/2/tasks/{taskID}/disable';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('PUT', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Disables a task using the v1 endpoint, please use `disableTask` instead.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $taskID         Unique identifier of a task. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskUpdateResponse
     *
     * @deprecated
     */
    public function disableTaskV1($taskID, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `disableTaskV1`.'
            );
        }

        $resourcePath = '/1/tasks/{taskID}/disable';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('PUT', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Enables a task.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $taskID         Unique identifier of a task. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskUpdateResponse
     */
    public function enableTask($taskID, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `enableTask`.'
            );
        }

        $resourcePath = '/2/tasks/{taskID}/enable';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('PUT', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Enables a task using the v1 endpoint, please use `enableTask` instead.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $taskID         Unique identifier of a task. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskUpdateResponse
     *
     * @deprecated
     */
    public function enableTaskV1($taskID, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `enableTaskV1`.'
            );
        }

        $resourcePath = '/1/tasks/{taskID}/enable';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('PUT', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves an authentication resource by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $authenticationID Unique identifier of an authentication resource. (required)
     * @param array  $requestOptions   the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Authentication
     */
    public function getAuthentication($authenticationID, $requestOptions = [])
    {
        // verify the required parameter 'authenticationID' is set
        if (!isset($authenticationID)) {
            throw new \InvalidArgumentException(
                'Parameter `authenticationID` is required when calling `getAuthentication`.'
            );
        }

        $resourcePath = '/1/authentications/{authenticationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $authenticationID) {
            $resourcePath = str_replace(
                '{authenticationID}',
                ObjectSerializer::toPathValue($authenticationID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a destination by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $destinationID  Unique identifier of a destination. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Destination
     */
    public function getDestination($destinationID, $requestOptions = [])
    {
        // verify the required parameter 'destinationID' is set
        if (!isset($destinationID)) {
            throw new \InvalidArgumentException(
                'Parameter `destinationID` is required when calling `getDestination`.'
            );
        }

        $resourcePath = '/1/destinations/{destinationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $destinationID) {
            $resourcePath = str_replace(
                '{destinationID}',
                ObjectSerializer::toPathValue($destinationID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a single task run event by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $runID          Unique identifier of a task run. (required)
     * @param string $eventID        Unique identifier of an event. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Event
     */
    public function getEvent($runID, $eventID, $requestOptions = [])
    {
        // verify the required parameter 'runID' is set
        if (!isset($runID)) {
            throw new \InvalidArgumentException(
                'Parameter `runID` is required when calling `getEvent`.'
            );
        }
        // verify the required parameter 'eventID' is set
        if (!isset($eventID)) {
            throw new \InvalidArgumentException(
                'Parameter `eventID` is required when calling `getEvent`.'
            );
        }

        $resourcePath = '/1/runs/{runID}/events/{eventID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $runID) {
            $resourcePath = str_replace(
                '{runID}',
                ObjectSerializer::toPathValue($runID),
                $resourcePath
            );
        }

        // path params
        if (null !== $eventID) {
            $resourcePath = str_replace(
                '{eventID}',
                ObjectSerializer::toPathValue($eventID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieve a single task run by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $runID          Unique identifier of a task run. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Run
     */
    public function getRun($runID, $requestOptions = [])
    {
        // verify the required parameter 'runID' is set
        if (!isset($runID)) {
            throw new \InvalidArgumentException(
                'Parameter `runID` is required when calling `getRun`.'
            );
        }

        $resourcePath = '/1/runs/{runID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $runID) {
            $resourcePath = str_replace(
                '{runID}',
                ObjectSerializer::toPathValue($runID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieve a source by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $sourceID       Unique identifier of a source. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Source
     */
    public function getSource($sourceID, $requestOptions = [])
    {
        // verify the required parameter 'sourceID' is set
        if (!isset($sourceID)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceID` is required when calling `getSource`.'
            );
        }

        $resourcePath = '/1/sources/{sourceID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $sourceID) {
            $resourcePath = str_replace(
                '{sourceID}',
                ObjectSerializer::toPathValue($sourceID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a task by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $taskID         Unique identifier of a task. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Task
     */
    public function getTask($taskID, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `getTask`.'
            );
        }

        $resourcePath = '/2/tasks/{taskID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a task by its ID using the v1 endpoint, please use `getTask` instead.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $taskID         Unique identifier of a task. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskV1
     *
     * @deprecated
     */
    public function getTaskV1($taskID, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `getTaskV1`.'
            );
        }

        $resourcePath = '/1/tasks/{taskID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a transformation by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $transformationID Unique identifier of a transformation. (required)
     * @param array  $requestOptions   the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Transformation
     */
    public function getTransformation($transformationID, $requestOptions = [])
    {
        // verify the required parameter 'transformationID' is set
        if (!isset($transformationID)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationID` is required when calling `getTransformation`.'
            );
        }

        $resourcePath = '/1/transformations/{transformationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $transformationID) {
            $resourcePath = str_replace(
                '{transformationID}',
                ObjectSerializer::toPathValue($transformationID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a list of all authentication resources.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param int   $itemsPerPage   Number of items per page. (optional, default to 10)
     * @param int   $page           Page number of the paginated API response. (optional)
     * @param array $type           Type of authentication resource to retrieve. (optional)
     * @param array $platform       Ecommerce platform for which to retrieve authentications. (optional)
     * @param array $sort           Property by which to sort the list of authentications. (optional)
     * @param array $order          Sort order of the response, ascending or descending. (optional)
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|ListAuthenticationsResponse
     */
    public function listAuthentications($itemsPerPage = null, $page = null, $type = null, $platform = null, $sort = null, $order = null, $requestOptions = [])
    {
        $resourcePath = '/1/authentications';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $itemsPerPage) {
            $queryParameters['itemsPerPage'] = $itemsPerPage;
        }

        if (null !== $page) {
            $queryParameters['page'] = $page;
        }

        if (is_array($type)) {
            $type = ObjectSerializer::serializeCollection($type, 'form', true);
        }
        if (null !== $type) {
            $queryParameters['type'] = $type;
        }

        if (is_array($platform)) {
            $platform = ObjectSerializer::serializeCollection($platform, 'form', true);
        }
        if (null !== $platform) {
            $queryParameters['platform'] = $platform;
        }

        if (null !== $sort) {
            $queryParameters['sort'] = $sort;
        }

        if (null !== $order) {
            $queryParameters['order'] = $order;
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a list of destinations.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param int    $itemsPerPage     Number of items per page. (optional, default to 10)
     * @param int    $page             Page number of the paginated API response. (optional)
     * @param array  $type             Destination type. (optional)
     * @param array  $authenticationID Authentication ID used by destinations. (optional)
     * @param string $transformationID Get the list of destinations used by a transformation. (optional)
     * @param array  $sort             Property by which to sort the destinations. (optional)
     * @param array  $order            Sort order of the response, ascending or descending. (optional)
     * @param array  $requestOptions   the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|ListDestinationsResponse
     */
    public function listDestinations($itemsPerPage = null, $page = null, $type = null, $authenticationID = null, $transformationID = null, $sort = null, $order = null, $requestOptions = [])
    {
        $resourcePath = '/1/destinations';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $itemsPerPage) {
            $queryParameters['itemsPerPage'] = $itemsPerPage;
        }

        if (null !== $page) {
            $queryParameters['page'] = $page;
        }

        if (is_array($type)) {
            $type = ObjectSerializer::serializeCollection($type, 'form', true);
        }
        if (null !== $type) {
            $queryParameters['type'] = $type;
        }

        if (is_array($authenticationID)) {
            $authenticationID = ObjectSerializer::serializeCollection($authenticationID, 'form', true);
        }
        if (null !== $authenticationID) {
            $queryParameters['authenticationID'] = $authenticationID;
        }

        if (is_array($transformationID)) {
            $transformationID = ObjectSerializer::serializeCollection($transformationID, 'form', true);
        }
        if (null !== $transformationID) {
            $queryParameters['transformationID'] = $transformationID;
        }

        if (null !== $sort) {
            $queryParameters['sort'] = $sort;
        }

        if (null !== $order) {
            $queryParameters['order'] = $order;
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a list of events for a task run, identified by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $runID          Unique identifier of a task run. (required)
     * @param int    $itemsPerPage   Number of items per page. (optional, default to 10)
     * @param int    $page           Page number of the paginated API response. (optional)
     * @param array  $status         Event status for filtering the list of task runs. (optional)
     * @param array  $type           Event type for filtering the list of task runs. (optional)
     * @param array  $sort           Property by which to sort the list of task run events. (optional)
     * @param array  $order          Sort order of the response, ascending or descending. (optional)
     * @param string $startDate      Date and time in RFC 3339 format for the earliest events to retrieve. By default, the current time minus three hours is used. (optional)
     * @param string $endDate        Date and time in RFC 3339 format for the latest events to retrieve. By default, the current time is used. (optional)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|ListEventsResponse
     */
    public function listEvents($runID, $itemsPerPage = null, $page = null, $status = null, $type = null, $sort = null, $order = null, $startDate = null, $endDate = null, $requestOptions = [])
    {
        // verify the required parameter 'runID' is set
        if (!isset($runID)) {
            throw new \InvalidArgumentException(
                'Parameter `runID` is required when calling `listEvents`.'
            );
        }

        $resourcePath = '/1/runs/{runID}/events';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $itemsPerPage) {
            $queryParameters['itemsPerPage'] = $itemsPerPage;
        }

        if (null !== $page) {
            $queryParameters['page'] = $page;
        }

        if (null !== $status) {
            $queryParameters['status'] = $status;
        }

        if (null !== $type) {
            $queryParameters['type'] = $type;
        }

        if (null !== $sort) {
            $queryParameters['sort'] = $sort;
        }

        if (null !== $order) {
            $queryParameters['order'] = $order;
        }

        if (null !== $startDate) {
            $queryParameters['startDate'] = $startDate;
        }

        if (null !== $endDate) {
            $queryParameters['endDate'] = $endDate;
        }

        // path params
        if (null !== $runID) {
            $resourcePath = str_replace(
                '{runID}',
                ObjectSerializer::toPathValue($runID),
                $resourcePath
            );
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieve a list of task runs.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param int    $itemsPerPage   Number of items per page. (optional, default to 10)
     * @param int    $page           Page number of the paginated API response. (optional)
     * @param array  $status         Run status for filtering the list of task runs. (optional)
     * @param array  $type           Run type for filtering the list of task runs. (optional)
     * @param string $taskID         Task ID for filtering the list of task runs. (optional)
     * @param array  $sort           Property by which to sort the list of task runs. (optional)
     * @param array  $order          Sort order of the response, ascending or descending. (optional)
     * @param string $startDate      Date in RFC 3339 format for the earliest run to retrieve. By default, the current day minus seven days is used. (optional)
     * @param string $endDate        Date in RFC 3339 format for the latest run to retrieve. By default, the current day is used. (optional)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|RunListResponse
     */
    public function listRuns($itemsPerPage = null, $page = null, $status = null, $type = null, $taskID = null, $sort = null, $order = null, $startDate = null, $endDate = null, $requestOptions = [])
    {
        $resourcePath = '/1/runs';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $itemsPerPage) {
            $queryParameters['itemsPerPage'] = $itemsPerPage;
        }

        if (null !== $page) {
            $queryParameters['page'] = $page;
        }

        if (null !== $status) {
            $queryParameters['status'] = $status;
        }

        if (null !== $type) {
            $queryParameters['type'] = $type;
        }

        if (null !== $taskID) {
            $queryParameters['taskID'] = $taskID;
        }

        if (null !== $sort) {
            $queryParameters['sort'] = $sort;
        }

        if (null !== $order) {
            $queryParameters['order'] = $order;
        }

        if (null !== $startDate) {
            $queryParameters['startDate'] = $startDate;
        }

        if (null !== $endDate) {
            $queryParameters['endDate'] = $endDate;
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a list of sources.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param int   $itemsPerPage     Number of items per page. (optional, default to 10)
     * @param int   $page             Page number of the paginated API response. (optional)
     * @param array $type             Source type. Some sources require authentication. (optional)
     * @param array $authenticationID Authentication IDs of the sources to retrieve. 'none' returns sources that doesn't have an authentication. (optional)
     * @param array $sort             Property by which to sort the list of sources. (optional)
     * @param array $order            Sort order of the response, ascending or descending. (optional)
     * @param array $requestOptions   the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|ListSourcesResponse
     */
    public function listSources($itemsPerPage = null, $page = null, $type = null, $authenticationID = null, $sort = null, $order = null, $requestOptions = [])
    {
        $resourcePath = '/1/sources';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $itemsPerPage) {
            $queryParameters['itemsPerPage'] = $itemsPerPage;
        }

        if (null !== $page) {
            $queryParameters['page'] = $page;
        }

        if (is_array($type)) {
            $type = ObjectSerializer::serializeCollection($type, 'form', true);
        }
        if (null !== $type) {
            $queryParameters['type'] = $type;
        }

        if (is_array($authenticationID)) {
            $authenticationID = ObjectSerializer::serializeCollection($authenticationID, 'form', true);
        }
        if (null !== $authenticationID) {
            $queryParameters['authenticationID'] = $authenticationID;
        }

        if (null !== $sort) {
            $queryParameters['sort'] = $sort;
        }

        if (null !== $order) {
            $queryParameters['order'] = $order;
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a list of tasks.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param int   $itemsPerPage           Number of items per page. (optional, default to 10)
     * @param int   $page                   Page number of the paginated API response. (optional)
     * @param array $action                 Actions for filtering the list of tasks. (optional)
     * @param bool  $enabled                Whether to filter the list of tasks by the `enabled` status. (optional)
     * @param array $sourceID               Source IDs for filtering the list of tasks. (optional)
     * @param array $sourceType             Filters the tasks with the specified source type. (optional)
     * @param array $destinationID          Destination IDs for filtering the list of tasks. (optional)
     * @param array $triggerType            Type of task trigger for filtering the list of tasks. (optional)
     * @param bool  $withEmailNotifications If specified, the response only includes tasks with notifications.email.enabled set to this value. (optional)
     * @param array $sort                   Property by which to sort the list of tasks. (optional)
     * @param array $order                  Sort order of the response, ascending or descending. (optional)
     * @param array $requestOptions         the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|ListTasksResponse
     */
    public function listTasks($itemsPerPage = null, $page = null, $action = null, $enabled = null, $sourceID = null, $sourceType = null, $destinationID = null, $triggerType = null, $withEmailNotifications = null, $sort = null, $order = null, $requestOptions = [])
    {
        $resourcePath = '/2/tasks';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $itemsPerPage) {
            $queryParameters['itemsPerPage'] = $itemsPerPage;
        }

        if (null !== $page) {
            $queryParameters['page'] = $page;
        }

        if (is_array($action)) {
            $action = ObjectSerializer::serializeCollection($action, 'form', true);
        }
        if (null !== $action) {
            $queryParameters['action'] = $action;
        }

        if (null !== $enabled) {
            $queryParameters['enabled'] = $enabled;
        }

        if (is_array($sourceID)) {
            $sourceID = ObjectSerializer::serializeCollection($sourceID, 'form', true);
        }
        if (null !== $sourceID) {
            $queryParameters['sourceID'] = $sourceID;
        }

        if (is_array($sourceType)) {
            $sourceType = ObjectSerializer::serializeCollection($sourceType, 'form', true);
        }
        if (null !== $sourceType) {
            $queryParameters['sourceType'] = $sourceType;
        }

        if (is_array($destinationID)) {
            $destinationID = ObjectSerializer::serializeCollection($destinationID, 'form', true);
        }
        if (null !== $destinationID) {
            $queryParameters['destinationID'] = $destinationID;
        }

        if (is_array($triggerType)) {
            $triggerType = ObjectSerializer::serializeCollection($triggerType, 'form', true);
        }
        if (null !== $triggerType) {
            $queryParameters['triggerType'] = $triggerType;
        }

        if (null !== $withEmailNotifications) {
            $queryParameters['withEmailNotifications'] = $withEmailNotifications;
        }

        if (null !== $sort) {
            $queryParameters['sort'] = $sort;
        }

        if (null !== $order) {
            $queryParameters['order'] = $order;
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a list of tasks using the v1 endpoint, please use `getTasks` instead.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param int   $itemsPerPage   Number of items per page. (optional, default to 10)
     * @param int   $page           Page number of the paginated API response. (optional)
     * @param array $action         Actions for filtering the list of tasks. (optional)
     * @param bool  $enabled        Whether to filter the list of tasks by the `enabled` status. (optional)
     * @param array $sourceID       Source IDs for filtering the list of tasks. (optional)
     * @param array $destinationID  Destination IDs for filtering the list of tasks. (optional)
     * @param array $triggerType    Type of task trigger for filtering the list of tasks. (optional)
     * @param array $sort           Property by which to sort the list of tasks. (optional)
     * @param array $order          Sort order of the response, ascending or descending. (optional)
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|ListTasksResponseV1
     *
     * @deprecated
     */
    public function listTasksV1($itemsPerPage = null, $page = null, $action = null, $enabled = null, $sourceID = null, $destinationID = null, $triggerType = null, $sort = null, $order = null, $requestOptions = [])
    {
        $resourcePath = '/1/tasks';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $itemsPerPage) {
            $queryParameters['itemsPerPage'] = $itemsPerPage;
        }

        if (null !== $page) {
            $queryParameters['page'] = $page;
        }

        if (is_array($action)) {
            $action = ObjectSerializer::serializeCollection($action, 'form', true);
        }
        if (null !== $action) {
            $queryParameters['action'] = $action;
        }

        if (null !== $enabled) {
            $queryParameters['enabled'] = $enabled;
        }

        if (is_array($sourceID)) {
            $sourceID = ObjectSerializer::serializeCollection($sourceID, 'form', true);
        }
        if (null !== $sourceID) {
            $queryParameters['sourceID'] = $sourceID;
        }

        if (is_array($destinationID)) {
            $destinationID = ObjectSerializer::serializeCollection($destinationID, 'form', true);
        }
        if (null !== $destinationID) {
            $queryParameters['destinationID'] = $destinationID;
        }

        if (is_array($triggerType)) {
            $triggerType = ObjectSerializer::serializeCollection($triggerType, 'form', true);
        }
        if (null !== $triggerType) {
            $queryParameters['triggerType'] = $triggerType;
        }

        if (null !== $sort) {
            $queryParameters['sort'] = $sort;
        }

        if (null !== $order) {
            $queryParameters['order'] = $order;
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Retrieves a list of transformations.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param int   $itemsPerPage   Number of items per page. (optional, default to 10)
     * @param int   $page           Page number of the paginated API response. (optional)
     * @param array $sort           Property by which to sort the list of transformations. (optional)
     * @param array $order          Sort order of the response, ascending or descending. (optional)
     * @param array $type           Whether to filter the list of transformations by the type of transformation. (optional)
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|ListTransformationsResponse
     */
    public function listTransformations($itemsPerPage = null, $page = null, $sort = null, $order = null, $type = null, $requestOptions = [])
    {
        $resourcePath = '/1/transformations';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        if (null !== $itemsPerPage) {
            $queryParameters['itemsPerPage'] = $itemsPerPage;
        }

        if (null !== $page) {
            $queryParameters['page'] = $page;
        }

        if (null !== $sort) {
            $queryParameters['sort'] = $sort;
        }

        if (null !== $order) {
            $queryParameters['order'] = $order;
        }

        if (null !== $type) {
            $queryParameters['type'] = $type;
        }

        return $this->sendRequest('GET', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Pushes records through the Pipeline, directly to an index. You can make the call synchronous by providing the `watch` parameter, for asynchronous calls, you can use the observability endpoints and/or debugger dashboard to see the status of your task. If you want to leverage the [pre-indexing data transformation](https://www.algolia.com/doc/guides/sending-and-managing-data/send-and-update-your-data/how-to/transform-your-data), this is the recommended way of ingesting your records. This method is similar to `pushTask`, but requires an `indexName` instead of a `taskID`. If zero or many tasks are found, an error will be returned.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string                $indexName       Name of the index on which to perform the operation. (required)
     * @param array|PushTaskPayload $pushTaskPayload pushTaskPayload (required)
     *                                               - $pushTaskPayload['action'] => (array)  (required)
     *                                               - $pushTaskPayload['records'] => (array)  (required)
     *
     * @see PushTaskPayload
     *
     * @param bool   $watch              When provided, the push operation will be synchronous and the API will wait for the ingestion to be finished before responding. (optional)
     * @param string $referenceIndexName This is required when targeting an index that does not have a push connector setup (e.g. a tmp index), but you wish to attach another index's transformation to it (e.g. the source index name). (optional)
     * @param array  $requestOptions     the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|WatchResponse
     */
    public function push($indexName, $pushTaskPayload, $watch = null, $referenceIndexName = null, $requestOptions = [])
    {
        // verify the required parameter 'indexName' is set
        if (!isset($indexName)) {
            throw new \InvalidArgumentException(
                'Parameter `indexName` is required when calling `push`.'
            );
        }
        // verify the required parameter 'pushTaskPayload' is set
        if (!isset($pushTaskPayload)) {
            throw new \InvalidArgumentException(
                'Parameter `pushTaskPayload` is required when calling `push`.'
            );
        }

        $resourcePath = '/1/push/{indexName}';
        $queryParameters = [];
        $headers = [];
        $httpBody = $pushTaskPayload;

        if (null !== $watch) {
            $queryParameters['watch'] = $watch;
        }

        if (null !== $referenceIndexName) {
            $queryParameters['referenceIndexName'] = $referenceIndexName;
        }

        // path params
        if (null !== $indexName) {
            $resourcePath = str_replace(
                '{indexName}',
                ObjectSerializer::toPathValue($indexName),
                $resourcePath
            );
        }

        if (!isset($requestOptions['readTimeout'])) {
            $requestOptions['readTimeout'] = 180;
        }
        if (!isset($requestOptions['writeTimeout'])) {
            $requestOptions['writeTimeout'] = 180;
        }
        if (!isset($requestOptions['connectTimeout'])) {
            $requestOptions['connectTimeout'] = 180;
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Pushes records through the pipeline, directly to an index. You can make the call synchronous by providing the `watch` parameter, for asynchronous calls, you can use the observability endpoints or the debugger dashboard to see the status of your task. If you want to transform your data before indexing, this is the recommended way of ingesting your records. This method is similar to `push`, but requires a `taskID` instead of a `indexName`, which is useful when many `destinations` target the same `indexName`.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string                $taskID          Unique identifier of a task. (required)
     * @param array|PushTaskPayload $pushTaskPayload pushTaskPayload (required)
     *                                               - $pushTaskPayload['action'] => (array)  (required)
     *                                               - $pushTaskPayload['records'] => (array)  (required)
     *
     * @see PushTaskPayload
     *
     * @param bool  $watch          When provided, the push operation will be synchronous and the API will wait for the ingestion to be finished before responding. (optional)
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|WatchResponse
     */
    public function pushTask($taskID, $pushTaskPayload, $watch = null, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `pushTask`.'
            );
        }
        // verify the required parameter 'pushTaskPayload' is set
        if (!isset($pushTaskPayload)) {
            throw new \InvalidArgumentException(
                'Parameter `pushTaskPayload` is required when calling `pushTask`.'
            );
        }

        $resourcePath = '/2/tasks/{taskID}/push';
        $queryParameters = [];
        $headers = [];
        $httpBody = $pushTaskPayload;

        if (null !== $watch) {
            $queryParameters['watch'] = $watch;
        }

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        if (!isset($requestOptions['readTimeout'])) {
            $requestOptions['readTimeout'] = 180;
        }
        if (!isset($requestOptions['writeTimeout'])) {
            $requestOptions['writeTimeout'] = 180;
        }
        if (!isset($requestOptions['connectTimeout'])) {
            $requestOptions['connectTimeout'] = 180;
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Fully updates a task by its ID, use partialUpdateTask if you only want to update a subset of fields.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string            $taskID      Unique identifier of a task. (required)
     * @param array|TaskReplace $taskReplace taskReplace (required)
     *                                       - $taskReplace['destinationID'] => (string) Universally unique identifier (UUID) of a destination resource. (required)
     *                                       - $taskReplace['action'] => (array)  (required)
     *                                       - $taskReplace['subscriptionAction'] => (array)
     *                                       - $taskReplace['cron'] => (string) Cron expression for the task's schedule.
     *                                       - $taskReplace['enabled'] => (bool) Whether the task is enabled.
     *                                       - $taskReplace['failureThreshold'] => (int) Maximum accepted percentage of failures for a task run to finish successfully.
     *                                       - $taskReplace['input'] => (array)
     *                                       - $taskReplace['cursor'] => (string) Date of the last cursor in RFC 3339 format.
     *                                       - $taskReplace['notifications'] => (array)
     *                                       - $taskReplace['policies'] => (array)
     *
     * @see TaskReplace
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskUpdateResponse
     */
    public function replaceTask($taskID, $taskReplace, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `replaceTask`.'
            );
        }
        // verify the required parameter 'taskReplace' is set
        if (!isset($taskReplace)) {
            throw new \InvalidArgumentException(
                'Parameter `taskReplace` is required when calling `replaceTask`.'
            );
        }

        $resourcePath = '/2/tasks/{taskID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = $taskReplace;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('PUT', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Runs all tasks linked to a source, only available for Shopify, BigCommerce and commercetools sources. Creates one run per task.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string                 $sourceID         Unique identifier of a source. (required)
     * @param array|RunSourcePayload $runSourcePayload (optional)
     *                                                 - $runSourcePayload['indexToInclude'] => (array) List of index names to include in reindex/update.
     *                                                 - $runSourcePayload['indexToExclude'] => (array) List of index names to exclude in reindex/update.
     *                                                 - $runSourcePayload['entityIDs'] => (array) List of entityIDs to update.
     *                                                 - $runSourcePayload['entityType'] => (array)
     *                                                 - $runSourcePayload['runMetadata'] => (array) Additional information that will be passed to the created runs.
     *
     * @see RunSourcePayload
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|RunSourceResponse
     */
    public function runSource($sourceID, $runSourcePayload = null, $requestOptions = [])
    {
        // verify the required parameter 'sourceID' is set
        if (!isset($sourceID)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceID` is required when calling `runSource`.'
            );
        }

        $resourcePath = '/1/sources/{sourceID}/run';
        $queryParameters = [];
        $headers = [];
        $httpBody = isset($runSourcePayload) ? $runSourcePayload : [];

        // path params
        if (null !== $sourceID) {
            $resourcePath = str_replace(
                '{sourceID}',
                ObjectSerializer::toPathValue($sourceID),
                $resourcePath
            );
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Runs a task. You can check the status of task runs with the observability endpoints.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string               $taskID         Unique identifier of a task. (required)
     * @param array|RunTaskPayload $runTaskPayload (optional)
     *                                             - $runTaskPayload['runMetadata'] => (array) Additional information that will be passed to the created run
     *
     * @see RunTaskPayload
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|RunResponse
     */
    public function runTask($taskID, $runTaskPayload = null, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `runTask`.'
            );
        }

        $resourcePath = '/2/tasks/{taskID}/run';
        $queryParameters = [];
        $headers = [];
        $httpBody = isset($runTaskPayload) ? $runTaskPayload : [];

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Runs a task using the v1 endpoint, please use `runTask` instead. You can check the status of task runs with the observability endpoints.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string               $taskID         Unique identifier of a task. (required)
     * @param array|RunTaskPayload $runTaskPayload (optional)
     *                                             - $runTaskPayload['runMetadata'] => (array) Additional information that will be passed to the created run
     *
     * @see RunTaskPayload
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|RunResponse
     *
     * @deprecated
     */
    public function runTaskV1($taskID, $runTaskPayload = null, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `runTaskV1`.'
            );
        }

        $resourcePath = '/1/tasks/{taskID}/run';
        $queryParameters = [];
        $headers = [];
        $httpBody = isset($runTaskPayload) ? $runTaskPayload : [];

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Searches for authentication resources.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|AuthenticationSearch $authenticationSearch authenticationSearch (required)
     *                                                         - $authenticationSearch['authenticationIDs'] => (array)  (required)
     *
     * @see AuthenticationSearch
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Authentication[]
     */
    public function searchAuthentications($authenticationSearch, $requestOptions = [])
    {
        // verify the required parameter 'authenticationSearch' is set
        if (!isset($authenticationSearch)) {
            throw new \InvalidArgumentException(
                'Parameter `authenticationSearch` is required when calling `searchAuthentications`.'
            );
        }

        $resourcePath = '/1/authentications/search';
        $queryParameters = [];
        $headers = [];
        $httpBody = $authenticationSearch;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Searches for destinations.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|DestinationSearch $destinationSearch destinationSearch (required)
     *                                                   - $destinationSearch['destinationIDs'] => (array)  (required)
     *
     * @see DestinationSearch
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Destination[]
     */
    public function searchDestinations($destinationSearch, $requestOptions = [])
    {
        // verify the required parameter 'destinationSearch' is set
        if (!isset($destinationSearch)) {
            throw new \InvalidArgumentException(
                'Parameter `destinationSearch` is required when calling `searchDestinations`.'
            );
        }

        $resourcePath = '/1/destinations/search';
        $queryParameters = [];
        $headers = [];
        $httpBody = $destinationSearch;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Searches for sources.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|SourceSearch $sourceSearch sourceSearch (required)
     *                                         - $sourceSearch['sourceIDs'] => (array)  (required)
     *
     * @see SourceSearch
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Source[]
     */
    public function searchSources($sourceSearch, $requestOptions = [])
    {
        // verify the required parameter 'sourceSearch' is set
        if (!isset($sourceSearch)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceSearch` is required when calling `searchSources`.'
            );
        }

        $resourcePath = '/1/sources/search';
        $queryParameters = [];
        $headers = [];
        $httpBody = $sourceSearch;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Searches for tasks.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|TaskSearch $taskSearch taskSearch (required)
     *                                     - $taskSearch['taskIDs'] => (array)  (required)
     *
     * @see TaskSearch
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Task[]
     */
    public function searchTasks($taskSearch, $requestOptions = [])
    {
        // verify the required parameter 'taskSearch' is set
        if (!isset($taskSearch)) {
            throw new \InvalidArgumentException(
                'Parameter `taskSearch` is required when calling `searchTasks`.'
            );
        }

        $resourcePath = '/2/tasks/search';
        $queryParameters = [];
        $headers = [];
        $httpBody = $taskSearch;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Searches for tasks using the v1 endpoint, please use `searchTasks` instead.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|TaskSearch $taskSearch taskSearch (required)
     *                                     - $taskSearch['taskIDs'] => (array)  (required)
     *
     * @see TaskSearch
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskV1[]
     *
     * @deprecated
     */
    public function searchTasksV1($taskSearch, $requestOptions = [])
    {
        // verify the required parameter 'taskSearch' is set
        if (!isset($taskSearch)) {
            throw new \InvalidArgumentException(
                'Parameter `taskSearch` is required when calling `searchTasksV1`.'
            );
        }

        $resourcePath = '/1/tasks/search';
        $queryParameters = [];
        $headers = [];
        $httpBody = $taskSearch;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Searches for transformations.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|TransformationSearch $transformationSearch transformationSearch (required)
     *                                                         - $transformationSearch['transformationIDs'] => (array)  (required)
     *
     * @see TransformationSearch
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|Transformation[]
     */
    public function searchTransformations($transformationSearch, $requestOptions = [])
    {
        // verify the required parameter 'transformationSearch' is set
        if (!isset($transformationSearch)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationSearch` is required when calling `searchTransformations`.'
            );
        }

        $resourcePath = '/1/transformations/search';
        $queryParameters = [];
        $headers = [];
        $httpBody = $transformationSearch;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Triggers a stream-listing request for a source. Triggering stream-listing requests only works with sources with `type: docker` and `imageType: airbyte`.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string $sourceID       Unique identifier of a source. (required)
     * @param array  $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|WatchResponse
     */
    public function triggerDockerSourceDiscover($sourceID, $requestOptions = [])
    {
        // verify the required parameter 'sourceID' is set
        if (!isset($sourceID)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceID` is required when calling `triggerDockerSourceDiscover`.'
            );
        }

        $resourcePath = '/1/sources/{sourceID}/discover';
        $queryParameters = [];
        $headers = [];
        $httpBody = null;

        // path params
        if (null !== $sourceID) {
            $resourcePath = str_replace(
                '{sourceID}',
                ObjectSerializer::toPathValue($sourceID),
                $resourcePath
            );
        }

        if (!isset($requestOptions['readTimeout'])) {
            $requestOptions['readTimeout'] = 180;
        }
        if (!isset($requestOptions['writeTimeout'])) {
            $requestOptions['writeTimeout'] = 180;
        }
        if (!isset($requestOptions['connectTimeout'])) {
            $requestOptions['connectTimeout'] = 180;
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Try a transformation before creating it.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|TransformationTry $transformationTry transformationTry (required)
     *                                                   - $transformationTry['code'] => (string) It is deprecated. Use the `input` field with proper `type` instead to specify the transformation code.
     *                                                   - $transformationTry['type'] => (array)
     *                                                   - $transformationTry['input'] => (array)
     *                                                   - $transformationTry['sampleRecord'] => (array) The record to apply the given code to. (required)
     *                                                   - $transformationTry['authentications'] => (array)
     *
     * @see TransformationTry
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TransformationTryResponse
     */
    public function tryTransformation($transformationTry, $requestOptions = [])
    {
        // verify the required parameter 'transformationTry' is set
        if (!isset($transformationTry)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationTry` is required when calling `tryTransformation`.'
            );
        }

        $resourcePath = '/1/transformations/try';
        $queryParameters = [];
        $headers = [];
        $httpBody = $transformationTry;

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Try a transformation before updating it.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string                  $transformationID  Unique identifier of a transformation. (required)
     * @param array|TransformationTry $transformationTry transformationTry (required)
     *                                                   - $transformationTry['code'] => (string) It is deprecated. Use the `input` field with proper `type` instead to specify the transformation code.
     *                                                   - $transformationTry['type'] => (array)
     *                                                   - $transformationTry['input'] => (array)
     *                                                   - $transformationTry['sampleRecord'] => (array) The record to apply the given code to. (required)
     *                                                   - $transformationTry['authentications'] => (array)
     *
     * @see TransformationTry
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TransformationTryResponse
     */
    public function tryTransformationBeforeUpdate($transformationID, $transformationTry, $requestOptions = [])
    {
        // verify the required parameter 'transformationID' is set
        if (!isset($transformationID)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationID` is required when calling `tryTransformationBeforeUpdate`.'
            );
        }
        // verify the required parameter 'transformationTry' is set
        if (!isset($transformationTry)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationTry` is required when calling `tryTransformationBeforeUpdate`.'
            );
        }

        $resourcePath = '/1/transformations/{transformationID}/try';
        $queryParameters = [];
        $headers = [];
        $httpBody = $transformationTry;

        // path params
        if (null !== $transformationID) {
            $resourcePath = str_replace(
                '{transformationID}',
                ObjectSerializer::toPathValue($transformationID),
                $resourcePath
            );
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Updates an authentication resource.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string                     $authenticationID     Unique identifier of an authentication resource. (required)
     * @param array|AuthenticationUpdate $authenticationUpdate authenticationUpdate (required)
     *                                                         - $authenticationUpdate['type'] => (array)
     *                                                         - $authenticationUpdate['name'] => (string) Descriptive name for the resource.
     *                                                         - $authenticationUpdate['input'] => (array)
     *
     * @see AuthenticationUpdate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|AuthenticationUpdateResponse
     */
    public function updateAuthentication($authenticationID, $authenticationUpdate, $requestOptions = [])
    {
        // verify the required parameter 'authenticationID' is set
        if (!isset($authenticationID)) {
            throw new \InvalidArgumentException(
                'Parameter `authenticationID` is required when calling `updateAuthentication`.'
            );
        }
        // verify the required parameter 'authenticationUpdate' is set
        if (!isset($authenticationUpdate)) {
            throw new \InvalidArgumentException(
                'Parameter `authenticationUpdate` is required when calling `updateAuthentication`.'
            );
        }

        $resourcePath = '/1/authentications/{authenticationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = $authenticationUpdate;

        // path params
        if (null !== $authenticationID) {
            $resourcePath = str_replace(
                '{authenticationID}',
                ObjectSerializer::toPathValue($authenticationID),
                $resourcePath
            );
        }

        return $this->sendRequest('PATCH', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Updates the destination by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string                  $destinationID     Unique identifier of a destination. (required)
     * @param array|DestinationUpdate $destinationUpdate destinationUpdate (required)
     *                                                   - $destinationUpdate['type'] => (array)
     *                                                   - $destinationUpdate['name'] => (string) Descriptive name for the resource.
     *                                                   - $destinationUpdate['input'] => (array)
     *                                                   - $destinationUpdate['authenticationID'] => (string) Universally unique identifier (UUID) of an authentication resource.
     *                                                   - $destinationUpdate['transformationIDs'] => (array)
     *
     * @see DestinationUpdate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|DestinationUpdateResponse
     */
    public function updateDestination($destinationID, $destinationUpdate, $requestOptions = [])
    {
        // verify the required parameter 'destinationID' is set
        if (!isset($destinationID)) {
            throw new \InvalidArgumentException(
                'Parameter `destinationID` is required when calling `updateDestination`.'
            );
        }
        // verify the required parameter 'destinationUpdate' is set
        if (!isset($destinationUpdate)) {
            throw new \InvalidArgumentException(
                'Parameter `destinationUpdate` is required when calling `updateDestination`.'
            );
        }

        $resourcePath = '/1/destinations/{destinationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = $destinationUpdate;

        // path params
        if (null !== $destinationID) {
            $resourcePath = str_replace(
                '{destinationID}',
                ObjectSerializer::toPathValue($destinationID),
                $resourcePath
            );
        }

        return $this->sendRequest('PATCH', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Updates a source by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string             $sourceID     Unique identifier of a source. (required)
     * @param array|SourceUpdate $sourceUpdate sourceUpdate (required)
     *                                         - $sourceUpdate['name'] => (string) Descriptive name of the source.
     *                                         - $sourceUpdate['input'] => (array)
     *                                         - $sourceUpdate['authenticationID'] => (string) Universally unique identifier (UUID) of an authentication resource.
     *
     * @see SourceUpdate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|SourceUpdateResponse
     */
    public function updateSource($sourceID, $sourceUpdate, $requestOptions = [])
    {
        // verify the required parameter 'sourceID' is set
        if (!isset($sourceID)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceID` is required when calling `updateSource`.'
            );
        }
        // verify the required parameter 'sourceUpdate' is set
        if (!isset($sourceUpdate)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceUpdate` is required when calling `updateSource`.'
            );
        }

        $resourcePath = '/1/sources/{sourceID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = $sourceUpdate;

        // path params
        if (null !== $sourceID) {
            $resourcePath = str_replace(
                '{sourceID}',
                ObjectSerializer::toPathValue($sourceID),
                $resourcePath
            );
        }

        return $this->sendRequest('PATCH', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Partially updates a task by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string           $taskID     Unique identifier of a task. (required)
     * @param array|TaskUpdate $taskUpdate taskUpdate (required)
     *                                     - $taskUpdate['destinationID'] => (string) Universally unique identifier (UUID) of a destination resource.
     *                                     - $taskUpdate['cron'] => (string) Cron expression for the task's schedule.
     *                                     - $taskUpdate['input'] => (array)
     *                                     - $taskUpdate['enabled'] => (bool) Whether the task is enabled.
     *                                     - $taskUpdate['subscriptionAction'] => (array)
     *                                     - $taskUpdate['failureThreshold'] => (int) Maximum accepted percentage of failures for a task run to finish successfully.
     *                                     - $taskUpdate['notifications'] => (array)
     *                                     - $taskUpdate['policies'] => (array)
     *
     * @see TaskUpdate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskUpdateResponse
     */
    public function updateTask($taskID, $taskUpdate, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `updateTask`.'
            );
        }
        // verify the required parameter 'taskUpdate' is set
        if (!isset($taskUpdate)) {
            throw new \InvalidArgumentException(
                'Parameter `taskUpdate` is required when calling `updateTask`.'
            );
        }

        $resourcePath = '/2/tasks/{taskID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = $taskUpdate;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('PATCH', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Updates a task by its ID using the v1 endpoint, please use `updateTask` instead.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string             $taskID     Unique identifier of a task. (required)
     * @param array|TaskUpdateV1 $taskUpdate taskUpdate (required)
     *                                       - $taskUpdate['destinationID'] => (string) Universally unique identifier (UUID) of a destination resource.
     *                                       - $taskUpdate['trigger'] => (array)
     *                                       - $taskUpdate['input'] => (array)
     *                                       - $taskUpdate['enabled'] => (bool) Whether the task is enabled.
     *                                       - $taskUpdate['failureThreshold'] => (int) Maximum accepted percentage of failures for a task run to finish successfully.
     *
     * @see TaskUpdateV1
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TaskUpdateResponse
     *
     * @deprecated
     */
    public function updateTaskV1($taskID, $taskUpdate, $requestOptions = [])
    {
        // verify the required parameter 'taskID' is set
        if (!isset($taskID)) {
            throw new \InvalidArgumentException(
                'Parameter `taskID` is required when calling `updateTaskV1`.'
            );
        }
        // verify the required parameter 'taskUpdate' is set
        if (!isset($taskUpdate)) {
            throw new \InvalidArgumentException(
                'Parameter `taskUpdate` is required when calling `updateTaskV1`.'
            );
        }

        $resourcePath = '/1/tasks/{taskID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = $taskUpdate;

        // path params
        if (null !== $taskID) {
            $resourcePath = str_replace(
                '{taskID}',
                ObjectSerializer::toPathValue($taskID),
                $resourcePath
            );
        }

        return $this->sendRequest('PATCH', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Updates a transformation by its ID.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string                     $transformationID     Unique identifier of a transformation. (required)
     * @param array|TransformationCreate $transformationCreate transformationCreate (required)
     *                                                         - $transformationCreate['code'] => (string) It is deprecated. Use the `input` field with proper `type` instead to specify the transformation code.
     *                                                         - $transformationCreate['name'] => (string) The uniquely identified name of your transformation. (required)
     *                                                         - $transformationCreate['type'] => (array)
     *                                                         - $transformationCreate['input'] => (array)
     *                                                         - $transformationCreate['description'] => (string) A descriptive name for your transformation of what it does.
     *                                                         - $transformationCreate['authenticationIDs'] => (array) The authentications associated with the current transformation.
     *
     * @see TransformationCreate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|TransformationUpdateResponse
     */
    public function updateTransformation($transformationID, $transformationCreate, $requestOptions = [])
    {
        // verify the required parameter 'transformationID' is set
        if (!isset($transformationID)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationID` is required when calling `updateTransformation`.'
            );
        }
        // verify the required parameter 'transformationCreate' is set
        if (!isset($transformationCreate)) {
            throw new \InvalidArgumentException(
                'Parameter `transformationCreate` is required when calling `updateTransformation`.'
            );
        }

        $resourcePath = '/1/transformations/{transformationID}';
        $queryParameters = [];
        $headers = [];
        $httpBody = $transformationCreate;

        // path params
        if (null !== $transformationID) {
            $resourcePath = str_replace(
                '{transformationID}',
                ObjectSerializer::toPathValue($transformationID),
                $resourcePath
            );
        }

        return $this->sendRequest('PUT', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Validates a source payload to ensure it can be created and that the data source can be reached by Algolia.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param array|SourceCreate $sourceCreate (optional)
     *                                         - $sourceCreate['type'] => (array)  (required)
     *                                         - $sourceCreate['name'] => (string) Descriptive name of the source. (required)
     *                                         - $sourceCreate['input'] => (array)
     *                                         - $sourceCreate['authenticationID'] => (string) Universally unique identifier (UUID) of an authentication resource.
     *
     * @see SourceCreate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|WatchResponse
     */
    public function validateSource($sourceCreate = null, $requestOptions = [])
    {
        $resourcePath = '/1/sources/validate';
        $queryParameters = [];
        $headers = [];
        $httpBody = isset($sourceCreate) ? $sourceCreate : [];

        if (!isset($requestOptions['readTimeout'])) {
            $requestOptions['readTimeout'] = 180;
        }
        if (!isset($requestOptions['writeTimeout'])) {
            $requestOptions['writeTimeout'] = 180;
        }
        if (!isset($requestOptions['connectTimeout'])) {
            $requestOptions['connectTimeout'] = 180;
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Validates an update of a source payload to ensure it can be created and that the data source can be reached by Algolia.
     *
     * Required API Key ACLs:
     *  - addObject
     *  - deleteIndex
     *  - editSettings
     *
     * @param string             $sourceID     Unique identifier of a source. (required)
     * @param array|SourceUpdate $sourceUpdate sourceUpdate (required)
     *                                         - $sourceUpdate['name'] => (string) Descriptive name of the source.
     *                                         - $sourceUpdate['input'] => (array)
     *                                         - $sourceUpdate['authenticationID'] => (string) Universally unique identifier (UUID) of an authentication resource.
     *
     * @see SourceUpdate
     *
     * @param array $requestOptions the requestOptions to send along with the query, they will be merged with the transporter requestOptions
     *
     * @return array<string, mixed>|WatchResponse
     */
    public function validateSourceBeforeUpdate($sourceID, $sourceUpdate, $requestOptions = [])
    {
        // verify the required parameter 'sourceID' is set
        if (!isset($sourceID)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceID` is required when calling `validateSourceBeforeUpdate`.'
            );
        }
        // verify the required parameter 'sourceUpdate' is set
        if (!isset($sourceUpdate)) {
            throw new \InvalidArgumentException(
                'Parameter `sourceUpdate` is required when calling `validateSourceBeforeUpdate`.'
            );
        }

        $resourcePath = '/1/sources/{sourceID}/validate';
        $queryParameters = [];
        $headers = [];
        $httpBody = $sourceUpdate;

        // path params
        if (null !== $sourceID) {
            $resourcePath = str_replace(
                '{sourceID}',
                ObjectSerializer::toPathValue($sourceID),
                $resourcePath
            );
        }

        if (!isset($requestOptions['readTimeout'])) {
            $requestOptions['readTimeout'] = 180;
        }
        if (!isset($requestOptions['writeTimeout'])) {
            $requestOptions['writeTimeout'] = 180;
        }
        if (!isset($requestOptions['connectTimeout'])) {
            $requestOptions['connectTimeout'] = 180;
        }

        return $this->sendRequest('POST', $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions);
    }

    /**
     * Helper: Chunks the given `objects` list in subset of 1000 elements max in order to make it fit in `batch` requests.
     *
     * @param string $indexName          the `indexName` to replace `objects` in
     * @param array  $objects            the array of `objects` to store in the given Algolia `indexName`
     * @param array  $action             the `batch` `action` to perform on the given array of `objects`, defaults to `addObject`
     * @param bool   $waitForTasks       whether or not we should wait until every `batch` tasks has been processed, this operation may slow the total execution time of this method but is more reliable
     * @param array  $batchSize          The size of the chunk of `objects`. The number of `push` calls will be equal to `length(objects) / batchSize`. Defaults to 1000.
     * @param array  $referenceIndexName This is required when targeting an index that does not have a push connector setup (e.g. a tmp index), but you wish to attach another index's transformation to it (e.g. the source index name).
     * @param array  $requestOptions     Request options
     */
    public function chunkedPush(
        $indexName,
        $objects,
        $action = 'addObject',
        $waitForTasks = true,
        $batchSize = 1000,
        $referenceIndexName = null,
        $requestOptions = []
    ) {
        $responses = [];
        $records = [];
        $count = 0;
        $offset = 0;
        $waitBatchSize = (int) ($batchSize / 10);
        if ($waitBatchSize < 1) {
            $waitBatchSize = $batchSize;
        }

        foreach ($objects as $object) {
            $records[] = $object;
            $ok = false;
            ++$count;

            if (sizeof($records) === $batchSize || $count === sizeof($objects)) {
                $responses[] = $this->push($indexName, ['action' => $action, 'records' => $records], false, $referenceIndexName, $requestOptions);
                $records = [];
            }

            if ($waitForTasks && !empty($responses) && (0 === sizeof($responses) % $waitBatchSize || $count === sizeof($objects))) {
                $timeoutCalculation = 'Algolia\AlgoliaSearch\Support\Helpers::linearTimeout';

                foreach (array_slice($responses, $offset, $waitBatchSize) as $response) {
                    $retry = 0;

                    while ($retry < 50) {
                        try {
                            $this->getEvent($response['runID'], $response['eventID']);

                            $ok = true;

                            break;
                        } catch (NotFoundException $e) {
                            // just retry
                        }

                        ++$retry;
                        usleep(
                            call_user_func_array($timeoutCalculation, [$this->config->getWaitTaskTimeBeforeRetry(), $retry])
                        );
                    }

                    if (false === $ok) {
                        throw new ExceededRetriesException('Maximum number of retries (50) exceeded.');
                    }
                }
                $offset = $offset + $waitBatchSize;
            }
        }

        return $responses;
    }

    private function sendRequest($method, $resourcePath, $headers, $queryParameters, $httpBody, $requestOptions, $useReadTransporter = false)
    {
        if (!isset($requestOptions['headers'])) {
            $requestOptions['headers'] = [];
        }
        if (!isset($requestOptions['queryParameters'])) {
            $requestOptions['queryParameters'] = [];
        }

        $requestOptions['headers'] = array_merge($headers, $requestOptions['headers']);
        $requestOptions['queryParameters'] = array_merge($queryParameters, $requestOptions['queryParameters']);
        $query = Query::build($requestOptions['queryParameters']);

        return $this->api->sendRequest(
            $method,
            $resourcePath.($query ? "?{$query}" : ''),
            $httpBody,
            $requestOptions,
            $useReadTransporter
        );
    }
}
